<?php
/*#################################################################################
	AdLogger
	- An open-source tracking tool for preventing click fraud

	Copyright 2006 by Trevor Fitzgerald
	http://www.adlogger.org

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

	If you find this script useful, please share it with others!

	Thank you!
*/#################################################################################

// Include the configuration files.
require ("../config_database.php");
require ("../config_settings.php");
require ("../config_admin.php");

// Make sure the person is logged in.
require ("./loginverify.php");

/*
 * Include the functions. Start the page timer, output the opening HTML,
 * and verify that we can actually connect to the database.
*/
require ("./functions.php");
	$start_time = micro_time(0);
	bodyHeader('archive', $version_num);
	bodyNavigation('archive');
	check_db_connection($adlogger_db_connect, $adlogger_db_select);

/*
 * If the person is looking for logs from a range,
 * grab the beginning and end date variables from the URL.
 */
if (!empty($_GET['begin_date']) && !empty($_GET['end_date'])) {

	$sortnum = $_GET['sortnum'];
	$begin_date = $_GET['begin_date'];
		$begin_date_timestamp = strtotime($begin_date);
	$end_date = $_GET['end_date'];
		$end_date_timestamp = strtotime($end_date);

	// UNIX timestamp of midnight of the beginning date
	$begin_date_timestamp = mktime(0, 0, 0, date('n', $begin_date_timestamp), date('d', $begin_date_timestamp), date('Y', $begin_date_timestamp));
	// UNIX timestamp of 23:59:59 of the end date
	$end_date_timestamp = mktime(23, 59, 59, date('n', $end_date_timestamp), date('d', $end_date_timestamp), date('Y', $end_date_timestamp));

	/*
	 * If the end date is before the beginning date,
	 * produce an error.
	 */
	if ($begin_date_timestamp > $end_date_timestamp) {
		echo '<div id="main-copy">
				<h1>Error!</h1>
				<p>The ending date cannot come before the beginning date.</p>
				<p>Please go back and try again.</p>
			</div>';
		bodyFooter('error', $start_time);
		exit();
	}

/*
 * If the person is only looking for logs for a specific date,
 * grab the beginning date from the URL
 */
} elseif (!empty($_GET['begin_date']) && empty($_GET['end_date'])) {

	$sortnum = $_GET['sortnum'];
	$begin_date = $_GET['begin_date'];
		$begin_date_timestamp = strtotime($begin_date);
	$end_date = '';

	// UNIX timestamp of midnight of the beginning date
	$begin_date_timestamp = mktime(0, 0, 0, date('n', $begin_date_timestamp), date('d', $begin_date_timestamp), date('Y', $begin_date_timestamp));
	// UNIX timestamp of 23:59:59 of the end date
	$end_date_timestamp = mktime(23, 59, 59, date('n', $begin_date_timestamp), date('d', $begin_date_timestamp), date('Y', $begin_date_timestamp));

/*
 * Else if nothing is in the URL, meaning the user just came
 * to the archive page, come up with some preliminary stats
 * to show him.
 */
} else {

	$sortnum = 10;
	$begin_date = date('m/d/Y', $timestamp);
	$end_date = '';
	
	// UNIX timestamp of midnight of the beginning date
	$begin_date_timestamp = mktime(0, 0, 0, date('n', $timestamp), date('d', $timestamp), date('Y', $timestamp));
	// UNIX timestamp of 23:59:59 of the end date
	$end_date_timestamp = mktime(23, 59, 59, date('n', $timestamp), date('d', $timestamp), date('Y', $timestamp));

}

// For pagination, we need to know what page we're trying to access
if (isset($_GET['pageno']) && !empty($_GET['pageno'])) {
   $pageno = $_GET['pageno'];
} else {
   $pageno = 1;
}

?>

<div id="side-bar">
	<div>
		<p class="sideBarTitle">Archive Data</p>
		<ul>
			<li><a href="#archive_preferences">&rsaquo; Preferences</a></li>
			<li><a href="#archive_statistics">&rsaquo; Archive Statistics</a></li>
			<li><a href="#cache-archived_clicks">&rsaquo; Archived Clicks</a></li>
		</ul>
	</div>
</div>

<div id="main-copy">
	<h1 id="archive_preferences">Archive Preferences</h1>

	<br />

	<form name="archive_date" action="<?php echo $_SERVER['PHP_SELF']; ?>" method="get" onsubmit="return validate_date_range(this);">
		<fieldset>

			<legend>Archive Preferences</legend>

			<div align="center">

				View 
				<select name="sortnum">
					<option value="10"<?php select_item_if_chosen('10', $sortnum); ?>>10</option>
					<option value="25"<?php select_item_if_chosen('25', $sortnum); ?>>25</option>
					<option value="50"<?php select_item_if_chosen('50', $sortnum); ?>>50</option>
				</select>
				clicks at a time for the period of time starting 
				<input name="begin_date" type="text" onfocus="showCalendarControl(this);" value="<?php echo $begin_date; ?>" size="10">
				and ending 
				<input name="end_date" type="text" onfocus="showCalendarControl(this);" value="<?php echo $end_date; ?>" size="10">

				<input type="submit" value="Sort" />

				<br /><br />

				* Leave end date blank to return values for a single date.
			</div>
		</fieldset>
	</form>

	<h1 id="archive_statistics">Archive Statistics</h1>

	<p>Archived Statistics:</p>

		<div align="center">
			<table summary="overview" width="75%" id="greytable">
				<thead id="greythead">
					<tr>
						<th scope="col">Date Range</th>
						<th scope="col">Total Clicks</th>
						<th scope="col">Unique Clicks</th>
					</tr>
				</thead>	
					<?php

					//Get the amount of clicks for the given date range
					$result = mysql_query("SELECT COUNT(id) FROM " . $db_table_prefix . "logfiles WHERE timestamp >= '$begin_date_timestamp' AND timestamp < $end_date_timestamp");
						$row = mysql_fetch_array($result);
						$archived_click_count = $row['COUNT(id)'];

					//Get number of unique clicks for the given date range
					$result = mysql_query("SELECT COUNT(DISTINCT visitor_ip) FROM " . $db_table_prefix . "logfiles WHERE timestamp >= '$begin_date_timestamp' AND timestamp < $end_date_timestamp");
						$row = mysql_fetch_array($result);
						$archived_unique_click_count = $row['COUNT(DISTINCT visitor_ip)'];
					?>
				<tbody id="greytbody">
					<tr>
						<th scope="row">
							<?php
								echo $begin_date;
								if (!empty($end_date)) {
									echo " - " . $end_date;
								}
							?>
						</th>
						<td><?php echo number_format($archived_click_count); ?></td>
						<td><?php echo number_format($archived_unique_click_count); ?></td>
					</tr>
				</tbody>	

			</table>
		</div>

	<h1 id="archived_clicks">Archived Clicks</h1>

	<p>Archived Clicks:</p>

	<div align="center">
<?php
/*
 * Start pagination code
 */
	$sql = "SELECT COUNT(id)
				FROM " . $db_table_prefix . "logfiles
					WHERE timestamp >= '$begin_date_timestamp'
						AND timestamp < $end_date_timestamp
							";
		$result = mysql_query($sql);
			$row = mysql_fetch_array($result);
			$numrows = $row['COUNT(id)'];

	if (isset($_GET['sortnum']) && !empty($_GET['sortnum'])) {
		$rows_per_page = $_GET['sortnum'];
	} else {
		$rows_per_page = 10;
	}
	$lastpage = ceil($numrows/$rows_per_page);
	if ($lastpage == 0) $lastpage = 1;

	$pageno = (int)$pageno;

	$limit = 'LIMIT ' .($pageno - 1) * $rows_per_page .',' .$rows_per_page;

	if ($pageno <= 1) {
		echo " FIRST PREV ";
	} else {
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=1&amp;sortnum=$rows_per_page&amp;begin_date=$begin_date&amp;end_date=$end_date#archived_clicks'>FIRST</a> ";
		$prevpage = $pageno - 1;
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$prevpage&amp;sortnum=$rows_per_page&amp;begin_date=$begin_date&amp;end_date=$end_date#archived_clicks'>PREV</a> ";
	}

	echo " ( Page $pageno of $lastpage ) ";

	if ($pageno >= $lastpage) {
		echo " NEXT LAST ";
	} else {
		$nextpage = $pageno + 1;
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$nextpage&amp;sortnum=$rows_per_page&amp;begin_date=$begin_date&amp;end_date=$end_date#archived_clicks'>NEXT</a> ";
		echo " <a href='{$_SERVER['PHP_SELF']}?pageno=$lastpage&amp;sortnum=$rows_per_page&amp;begin_date=$begin_date&amp;end_date=$end_date#archived_clicks'>LAST</a> ";
	}
###################################################
?>
	</div>
	<br />

	<?php if ($numrows > 0) { ?>

			<table summary="all_clicks" width="100%" id="greytable">
				<thead id="greythead">
					<tr>
						<th scope="col">Click ID</th>
						<th scope="col">Date</th>
						<th scope="col">Time</th>
						<th scope="col">IP Address</th>
						<th scope="col">Display Page URL</th>
					</tr>
				</thead>
				<tbody id="greytbody">

				<?php
					/*
					 * Perform the query on the database to grab the rows.
					*/
					$sql = "SELECT *
								FROM " . $db_table_prefix . "logfiles
									WHERE timestamp >= '$begin_date_timestamp'
										AND timestamp < $end_date_timestamp
										ORDER BY timestamp DESC
											$limit
												";
						$result = mysql_query($sql) or die(mysql_error());
							/*
							 * Start the loop to display them.  In this loop, the script creates
							 * a new table row for each entry it finds from the database.
							*/
							while($row = mysql_fetch_array($result)) {
								$id = $row['id'];
								$timestamp = $row['timestamp'];
									// Convert that UNIX timestamp to something a little more useable
									$date = date('M j, Y', $timestamp);
									$time = date('g:i:s a', $timestamp);
								$visitor_ip = $row['visitor_ip'];
								$disp_url = urldecode($row['disp_url']);
					?>
								<tr class="odd">
									<th scope="row"><a href="./click_info.php?id=<?php echo $id; ?>"><?php echo $id; ?></a></th>
									<td><?php echo $date; ?></td>
									<td><?php echo $time; ?></td>
									<td><?php echo $visitor_ip; ?></td>
									<td><?php echo shortenURL($disp_url); ?></td>
								</tr>
						<?php } /* End the loop. */ ?>

				</tbody>
			</table>
	<?php } else { ?>
		<p><strong>There are no click logs for the specified time period.</strong></p>
	<?php } ?>

</div>
<?php bodyFooter('archive', $start_time); ?>